package ru.yandex.travel.commons.retry;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;

import lombok.Builder;
import lombok.Getter;

@Getter
@Builder
public class SpeculativeRetryStrategy<T> {
    Function<Exception, Boolean> shouldRetryOnException;
    Consumer<T> validateResult; // Retry if anything is thrown

    private final int numRetries;
    private final Duration retryDelay;
    private final Duration timeout;
}
