package ru.yandex.travel.commons.retry;

public class UnacceptedResultException extends RuntimeException {
    private final Object result;

    public UnacceptedResultException(Object result) {
        super(String.format("Invocation with unaccepted result: %s", result));
        this.result = result;
    }

    public Object getResult() {
        return result;
    }
}
