package ru.yandex.travel.commons.streams;

import java.math.BigDecimal;
import java.util.stream.Collector;
import java.util.stream.Collectors;

import javax.money.CurrencyUnit;

import org.javamoney.moneta.Money;

public class CustomCollectors {
    public static <T> Collector<T, ?, BigDecimal> summingBigDecimal(ToDecimalFunction<T> mapper) {
        return new DecimalSumCollector<>(mapper);
    }

    public static <T> Collector<T, ?, Money> summingMoney(ToMoneyFunction<T> mapper, CurrencyUnit currency) {
        return new MoneySumCollector<>(mapper, currency);
    }

    public static <T> Collector<T, ?, T> exactlyOne() {
        return Collectors.collectingAndThen(
                Collectors.toList(),
                list -> {
                    if (list.size() != 1) {
                        throw new IllegalStateException(String.format("Exactly one element required, %d found", list.size()));
                    }
                    return list.get(0);
                }
        );
    }

    public static <T> Collector<T, ?, T> atMostOne() {
        return Collectors.collectingAndThen(
                Collectors.toList(),
                list -> {
                    if (list.size() > 1) {
                        throw new IllegalStateException(String.format("At most one element expected, %d found", list.size()));
                    }
                    return list.size() == 1 ? list.get(0) : null;
                }
        );
    }
}
