package ru.yandex.travel.commons.streams;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class DecimalSumCollector<T> implements Collector<T, BigDecimal[], BigDecimal> {
    private final ToDecimalFunction<T> mapper;

    public DecimalSumCollector(ToDecimalFunction<T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Supplier<BigDecimal[]> supplier() {
        return () -> {
            BigDecimal[] res = new BigDecimal[1];
            res[0] = BigDecimal.ZERO;
            return res;
        };
    }

    @Override
    public BiConsumer<BigDecimal[], T> accumulator() {
        return (a, t) -> {
            BigDecimal v = mapper.applyAsBigDecimal(t);
            a[0] = a[0].add(v);
        };
    }

    @Override
    public BinaryOperator<BigDecimal[]> combiner() {
        return (a, b) -> {
            a[0] = a[0].add(b[0]);
            return a;
        };
    }

    @Override
    public Function<BigDecimal[], BigDecimal> finisher() {
        return a -> a[0];
    }

    @Override
    public Set<Characteristics> characteristics() {
        return Collections.emptySet();
    }
}
