package ru.yandex.travel.commons.streams;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

import javax.money.CurrencyUnit;

import org.javamoney.moneta.Money;

public class MoneySumCollector<T> implements Collector<T, Money[], Money> {
    private final ToMoneyFunction<T> mapper;
    private final CurrencyUnit currency;

    public MoneySumCollector(ToMoneyFunction<T> mapper, CurrencyUnit currency) {
        this.mapper = mapper;
        this.currency = currency;
    }

    @Override
    public Supplier<Money[]> supplier() {
        return () -> {
            Money[] res = new Money[1];
            res[0] = Money.zero(currency);
            return res;
        };
    }

    @Override
    public BiConsumer<Money[], T> accumulator() {
        return (a, t) -> {
            Money v = mapper.applyAsMoney(t);
            a[0] = a[0].add(v);
        };
    }

    @Override
    public BinaryOperator<Money[]> combiner() {
        return (a, b) -> {
            a[0] = a[0].add(b[0]);
            return a;
        };
    }

    @Override
    public Function<Money[], Money> finisher() {
        return a -> a[0];
    }

    @Override
    public Set<Characteristics> characteristics() {
        return Collections.emptySet();
    }
}
