package ru.yandex.travel.commons.yt;

import java.util.HashMap;
import java.util.Map;

import lombok.Data;

@Data
public class BaseYtProperties {
    private static final String DEFAULT_KEY = "default";
    private Map<String, YtClusterProperties> clusters = new HashMap<>();

    public YtClusterPropertiesInterface getClusterConfigFor(String clusterName) {
        YtClusterProperties properties;
        YtClusterPropertiesInterface config = new YtClusterPropertiesWithDefaults();
        properties = clusters.get(DEFAULT_KEY);
        if (properties != null) {
            config = new YtClusterPropertiesWithOverridesAndFallback(properties, config);
        }
        properties = clusters.get(clusterName);
        if (properties != null) {
            config = new YtClusterPropertiesWithOverridesAndFallback(properties, config);
        }
        return config;
    }
}
