package ru.yandex.travel.commons.yt;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.travel.commons.proto.EMessageCodec;

@Data
@EqualsAndHashCode(callSuper = true)
public class ClientReplicatedYtProperties extends BaseYtProperties {

    private List<String> sinkClusters = new ArrayList<>();
    private int minWritesToContinue = 1;
    private int minReadsToContinue = 1;
    private EMessageCodec messageCodec;
    private int compressionLevel;
    private Duration pingLifetime = Duration.ofSeconds(30);
    private boolean perInstancePingId = false;

}
