package ru.yandex.travel.commons.yt;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;

import ru.yandex.travel.commons.metrics.MetricsUtils;

public class YtAdapterMetricsHelper {
    private YtAdapterMetricsHelper() {
    }

    public static Timer createTimer(String name, String... tags) {
        return Timer.builder(name).tags(tags)
                .publishPercentiles(MetricsUtils.higherPercentiles())
                .serviceLevelObjectives(MetricsUtils.smallDurationSla())
                .register(Metrics.globalRegistry);
    }

    public static Timer createTimerWithExtendedBuckets(String name, String... tags) {
        return Timer.builder(name).tags(tags)
                .publishPercentiles(MetricsUtils.higherPercentiles())
                .serviceLevelObjectives(MetricsUtils.smallDurationSlaExtended())
                .register(Metrics.globalRegistry);
    }
}
