package ru.yandex.travel.commons.yt;

import java.time.Duration;

public class YtClusterProperties implements YtClusterPropertiesInterface {
    private String user;
    private String token;

    private Duration failoverTimeout;
    private Duration globalTimeout;
    private Duration pingTimeout;
    private Duration clientTimeout;

    private String tablePath;
    private int maxConcurrentWrites;
    private int maxBatchSize;
    private int maxQueueSize;
    private Duration healthCheckTimeout;
    private Duration healthCheckInterval;

    private Duration sendingTimeout;
    private Duration sendingInterval;
    private boolean switchOnErrors;
    private boolean newDiscoveryService;


    @Override
    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public Duration getFailoverTimeout() {
        return failoverTimeout;
    }

    public void setFailoverTimeout(Duration failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
    }

    @Override
    public Duration getGlobalTimeout() {
        return globalTimeout;
    }

    public void setGlobalTimeout(Duration globalTimeout) {
        this.globalTimeout = globalTimeout;
    }

    @Override
    public Duration getPingTimeout() {
        return pingTimeout;
    }

    public void setPingTimeout(Duration pingTimeout) {
        this.pingTimeout = pingTimeout;
    }

    @Override
    public Duration getClientTimeout() {
        return clientTimeout;
    }

    public void setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    @Override
    public String getTablePath() {
        return tablePath;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    @Override
    public int getMaxConcurrentWrites() {
        return maxConcurrentWrites;
    }

    @Override
    public int getMaxBatchSize() {
        return maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public int getMaxQueueSize() {
        return maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public void setMaxConcurrentWrites(int maxConcurrentWrites) {
        this.maxConcurrentWrites = maxConcurrentWrites;
    }

    @Override
    public Duration getHealthCheckTimeout() {
        return healthCheckTimeout;
    }

    public void setHealthCheckTimeout(Duration healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    @Override
    public Duration getHealthCheckInterval() {
        return healthCheckInterval;
    }

    public void setHealthCheckInterval(Duration healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
    }

    @Override
    public Duration getSendingInterval() {
        return sendingInterval;
    }

    public void setSendingInterval(Duration sendingInterval) {
        this.sendingInterval = sendingInterval;
    }

    @Override
    public Duration getSendingTimeout() {
        return null;
    }

    public void setSendingTimeout(Duration sendingTimeout) {
        this.sendingTimeout = sendingTimeout;
    }


    @Override
    public boolean isSwitchOnErrors() {
        return switchOnErrors;
    }

    public YtClusterProperties setSwitchOnErrors(boolean switchOnErrors) {
        this.switchOnErrors = switchOnErrors;
        return this;
    }

    @Override
    public boolean isNewDiscoveryService() {
        return newDiscoveryService;
    }

    public YtClusterProperties setNewDiscoveryService(boolean newDiscoveryService) {
        this.newDiscoveryService = newDiscoveryService;
        return this;
    }
}
