package ru.yandex.travel.commons.yt;

import java.time.Duration;

public interface YtClusterPropertiesInterface {
    // Connection properties.

    String getUser();

    String getToken();

    Duration getFailoverTimeout();

    Duration getGlobalTimeout();

    Duration getPingTimeout();

    Duration getClientTimeout();

    // Sink properties.

    String getTablePath();

    int getMaxConcurrentWrites();
    int getMaxBatchSize();
    int getMaxQueueSize();


    Duration getHealthCheckTimeout();

    Duration getHealthCheckInterval();

    Duration getSendingInterval();

    Duration getSendingTimeout();

    boolean isSwitchOnErrors();

    boolean isNewDiscoveryService();
}
