package ru.yandex.travel.commons.yt;

import java.time.Duration;
import java.util.function.Function;

public class YtClusterPropertiesWithOverridesAndFallback implements YtClusterPropertiesInterface {
    private final YtClusterPropertiesInterface overrides;
    private final YtClusterPropertiesInterface fallbacks;

    public YtClusterPropertiesWithOverridesAndFallback(YtClusterPropertiesInterface overrides,
                                                       YtClusterPropertiesInterface fallbacks) {
        this.overrides = overrides;
        this.fallbacks = fallbacks;
    }

    private String getString(Function<YtClusterPropertiesInterface, String> getter) {
        String value = getter.apply(overrides);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return getter.apply(fallbacks);
    }

    private Duration getDuration(Function<YtClusterPropertiesInterface, Duration> getter) {
        Duration value = getter.apply(overrides);
        if (value != null && !value.isZero()) {
            return value;
        }
        return getter.apply(fallbacks);
    }

    @Override
    public String getUser() {
        return getString(YtClusterPropertiesInterface::getUser);
    }

    @Override
    public String getToken() {
        return getString(YtClusterPropertiesInterface::getToken);
    }

    @Override
    public Duration getFailoverTimeout() {
        return getDuration(YtClusterPropertiesInterface::getFailoverTimeout);
    }

    @Override
    public Duration getGlobalTimeout() {
        return getDuration(YtClusterPropertiesInterface::getGlobalTimeout);
    }

    @Override
    public Duration getPingTimeout() {
        return getDuration(YtClusterPropertiesInterface::getPingTimeout);
    }

    @Override
    public Duration getClientTimeout() {
        return getDuration(YtClusterPropertiesInterface::getClientTimeout);
    }

    @Override
    public String getTablePath() {
        return getString(YtClusterPropertiesInterface::getTablePath);
    }

    @Override
    public int getMaxConcurrentWrites() {
        if (overrides.getMaxConcurrentWrites() > 0) {
            return overrides.getMaxConcurrentWrites();
        } else {
            return fallbacks.getMaxConcurrentWrites();
        }
    }

    @Override
    public int getMaxBatchSize() {
        if (overrides.getMaxBatchSize() > 0) {
            return overrides.getMaxBatchSize();
        } else {
            return fallbacks.getMaxBatchSize();
        }
    }

    @Override
    public int getMaxQueueSize() {
        if (overrides.getMaxQueueSize() > 0) {
            return overrides.getMaxQueueSize();
        } else {
            return fallbacks.getMaxQueueSize();
        }
    }

    @Override
    public Duration getHealthCheckTimeout() {
        return getDuration(YtClusterPropertiesInterface::getHealthCheckTimeout);
    }

    @Override
    public Duration getHealthCheckInterval() {
        return getDuration(YtClusterPropertiesInterface::getHealthCheckInterval);
    }

    @Override
    public Duration getSendingInterval() {
        return getDuration(YtClusterPropertiesInterface::getSendingInterval);
    }

    @Override
    public Duration getSendingTimeout() {
        return getDuration(YtClusterPropertiesInterface::getSendingTimeout);
    }

    @Override
    public boolean isSwitchOnErrors() {
        if (overrides.isSwitchOnErrors()) {
            return overrides.isSwitchOnErrors();
        } else {
            return fallbacks.isSwitchOnErrors();
        }
    }

    @Override
    public boolean isNewDiscoveryService() {
        if (overrides.isNewDiscoveryService()) {
            return overrides.isNewDiscoveryService();
        } else {
            return fallbacks.isNewDiscoveryService();
        }
    }
}
