SET(async_http_client_version 2.4.9)
SET(flyway_version 6.4.4)
SET(grpc_version 1.43.2)
SET(guava_version 26.0-jre)
SET(hibernate_version 5.4.1.Final)
SET(jackson_version 2.11.3)
SET(log4j_version 2.15.0)
SET(lucene_version 7.5.0)
SET(moneta_version 1.3)
SET(mockito_version 3.11.2)
SET(netty_version 4.1.63.Final)
SET(slf4j_version 1.7.25)
SET(spring_boot_version 2.3.2.RELEASE)
SET(spring_batch_version 4.2.4.RELEASE)  # depends on spring_boot_version
SET(spring_integration_version 5.3.8.RELEASE) # depends on spring_boot_version
SET(spring_version 5.2.8.RELEASE) # depends on spring_boot_version
SET(swagger_version 2.8.0)
SET(sentry_version 1.7.27)
SET(micrometer_version 1.5.3)
SET(junit5_jupiter_version 5.6.2) # should depend on spring_boot_version
SET(assertj_version 3.16.1)
SET(opentracing_version 0.33.0)
SET(jooq_version 3.13.2)
SET(poi_version 4.1.2)
SET(kotlin_versions 1.5.10)

EXCLUDE(
    contrib/java/com/google/protobuf/protobuf-javalite
    contrib/java/com/vaadin/external/google/android-json
    contrib/java/com/zaxxer/HikariCP-java6/2.3.13
    contrib/java/javax/servlet/javax.servlet-api/3.0.1
    contrib/java/log4j/log4j/1.2.17
    contrib/java/org/springframework/boot/spring-boot-starter-logging
    contrib/java/org/springframework/boot/spring-boot-starter-tomcat
)

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/junit/junit-bom/${junit5_jupiter_version}/ya.dependency_management.inc)
DEPENDENCY_MANAGEMENT(
    # spring boot
    contrib/java/org/springframework/boot/spring-boot/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-autoconfigure/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-actuator/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-batch/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-data-jpa/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-quartz/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-jdbc/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-jetty/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-json/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-log4j2/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-logging/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-security/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-web/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-integration/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-test/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-test/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-configuration-processor/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-validation/${spring_boot_version}

    # spring
    contrib/java/org/springframework/spring-aop/${spring_version}
    contrib/java/org/springframework/spring-aspects/${spring_version}
    contrib/java/org/springframework/spring-beans/${spring_version}
    contrib/java/org/springframework/spring-context/${spring_version}
    contrib/java/org/springframework/spring-core/${spring_version}
    contrib/java/org/springframework/spring-expression/${spring_version}
    contrib/java/org/springframework/spring-jcl/${spring_version}
    contrib/java/org/springframework/spring-jdbc/${spring_version}
    contrib/java/org/springframework/spring-orm/${spring_version}
    contrib/java/org/springframework/spring-test/${spring_version}
    contrib/java/org/springframework/spring-tx/${spring_version}
    contrib/java/org/springframework/batch/spring-batch-test/${spring_batch_version}

    contrib/java/org/springframework/integration/spring-integration-core/${spring_integration_version}
    contrib/java/org/springframework/integration/spring-integration-event/${spring_integration_version}
    contrib/java/org/springframework/integration/spring-integration-jms/${spring_integration_version}
    contrib/java/org/springframework/integration/spring-integration-test-support/${spring_integration_version}

    #swagger
    contrib/java/io/springfox/springfox-swagger2/${swagger_version}
    contrib/java/io/springfox/springfox-swagger-ui/${swagger_version}

    # grpc
    contrib/java/io/grpc/grpc-all/${grpc_version}
    contrib/java/io/grpc/grpc-auth/${grpc_version}
    contrib/java/io/grpc/grpc-context/${grpc_version}
    contrib/java/io/grpc/grpc-core/${grpc_version}
    contrib/java/io/grpc/grpc-netty/${grpc_version}
    contrib/java/io/grpc/grpc-okhttp/${grpc_version}
    contrib/java/io/grpc/grpc-protobuf/${grpc_version}
    contrib/java/io/grpc/grpc-protobuf-lite/${grpc_version}
    contrib/java/io/grpc/grpc-protobuf-nano/${grpc_version}
    contrib/java/io/grpc/grpc-services/${grpc_version}
    contrib/java/io/grpc/grpc-stub/${grpc_version}
    contrib/java/io/grpc/grpc-testing/${grpc_version}

    # guava
    contrib/java/com/google/guava/guava/${guava_version}

    # async http client
    contrib/java/org/asynchttpclient/async-http-client/${async_http_client_version}

    # netty
    contrib/java/io/netty/netty-codec-http2/${netty_version}
    contrib/java/io/netty/netty-codec/${netty_version}
    contrib/java/io/netty/netty-transport/${netty_version}
    contrib/java/io/netty/netty-common/${netty_version}
    contrib/java/io/netty/netty-codec/${netty_version}
    contrib/java/io/netty/netty-buffer/${netty_version}
    contrib/java/io/netty/netty-codec-http/${netty_version}
    contrib/java/io/netty/netty-codec-socks/${netty_version}
    contrib/java/io/netty/netty-handler/${netty_version}
    contrib/java/io/netty/netty-handler-proxy/${netty_version}

    # slf4j
    contrib/java/org/slf4j/slf4j-api/${slf4j_version}
    contrib/java/org/slf4j/slf4j-simple/${slf4j_version}
    contrib/java/org/slf4j/jul-to-slf4j/${slf4j_version}

    # log4j
    contrib/java/org/apache/logging/log4j/log4j-api/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-core/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-jcl/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-1.2-api/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-1.2-api/${log4j_version}

    # servlet
    contrib/java/javax/servlet/javax.servlet-api/3.1.0

    # hibernate
    contrib/java/org/hibernate/hibernate-core/${hibernate_version}
    contrib/java/org/hibernate/hibernate-envers/${hibernate_version}

    # junit
    contrib/java/junit/junit/4.12
    contrib/java/com/google/code/gson/gson/2.8.7

    # flyway
    contrib/java/org/flywaydb/flyway-core/${flyway_version}
    contrib/java/org/flywaydb/flyway-commandline/${flyway_version}

    # h2 database
    contrib/java/com/h2database/h2/1.4.199

    # postgresql database
    contrib/java/org/postgresql/postgresql/42.2.4

    #jackson
    contrib/java/com/fasterxml/jackson/core/jackson-core/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jsr310/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8/${jackson_version}
    contrib/java/com/fasterxml/jackson/module/jackson-module-kotlin/${jackson_version}

    # moneta
    contrib/java/org/javamoney/moneta/moneta-core/${moneta_version}
    contrib/java/org/javamoney/moneta/moneta-convert/${moneta_version}
    contrib/java/org/javamoney/moneta/moneta-convert-imf/${moneta_version}
    contrib/java/org/javamoney/moneta/moneta-convert-ecb/${moneta_version}

    # mockito
    contrib/java/org/mockito/mockito-core/${mockito_version}
    contrib/java/org/mockito/mockito-inline/${mockito_version}

    # aws libraries
    contrib/java/com/amazonaws/aws-java-sdk-sqs/1.11.336
    contrib/java/com/amazonaws/aws-java-sdk-s3/1.11.792
    contrib/java/com/amazonaws/aws-java-sdk-sqs/1.11.792

    # apache http (aws deps)
    contrib/java/org/apache/httpcomponents/httpclient/4.5.9
    contrib/java/org/apache/httpcomponents/httpcore/4.4.11

    # misc
    contrib/java/net/bytebuddy/byte-buddy/1.9.7
    contrib/java/it/unimi/dsi/fastutil/8.1.1

    # quartz
    contrib/java/org/quartz-scheduler/quartz/2.3.0

    # lucene
    contrib/java/org/apache/lucene/lucene-core/${lucene_version}
    contrib/java/org/apache/lucene/lucene-analyzers-common/${lucene_version}
    contrib/java/org/apache/lucene/lucene-queryparser/${lucene_version}

    # jook
    contrib/java/org/jooq/jooq/${jooq_version}
    contrib/java/org/jooq/jooq-codegen/${jooq_version}

    contrib/java/net/java/dev/jna/jna/4.5.2

    contrib/java/javax/xml/bind/jaxb-api/2.3.1
    contrib/java/javax/validation/validation-api/2.0.1.Final
    contrib/java/org/hibernate/validator/hibernate-validator/6.0.18.Final

    contrib/java/org/reflections/reflections/0.9.11

    contrib/java/org/dom4j/dom4j/2.1.0

    contrib/java/javax/mail/mail/1.4.3
    contrib/java/javax/mail/mailapi/1.4.3

    contrib/java/io/sentry/sentry/${sentry_version}
    contrib/java/io/sentry/sentry-spring/${sentry_version}

    contrib/java/io/micrometer/micrometer-core/${micrometer_version}

    contrib/java/org/assertj/assertj-core/${assertj_version}

    contrib/java/com/github/ben-manes/caffeine/caffeine/2.8.0

    # opentracing
    contrib/java/io/opentracing/opentracing-api/${opentracing_version}
    contrib/java/io/opentracing/opentracing-util/${opentracing_version}
    contrib/java/io/opentracing/opentracing-noop/${opentracing_version}
    contrib/java/io/opentracing/opentracing-mock/${opentracing_version}

    # kotlin
    contrib/java/org/jetbrains/kotlin/kotlin-stdlib-jdk8/${kotlin_versions}
    contrib/java/org/jetbrains/kotlin/kotlin-stdlib/${kotlin_versions}
    contrib/java/org/jetbrains/kotlin/kotlin-stdlib-common/${kotlin_versions}
    contrib/java/org/jetbrains/kotlin/kotlin-stdlib-jdk7/${kotlin_versions}
    contrib/java/org/jetbrains/kotlin/kotlin-reflect/${kotlin_versions}

    # mapstruct
    contrib/java/org/mapstruct/mapstruct/1.4.1.Final
    contrib/java/org/mapstruct/mapstruct-processor/1.4.1.Final
)

