package ru.yandex.travel.orders.client;

import java.time.Duration;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.orders.client.yp.YpDiscoveryProperties;

@Getter
@Setter
@Validated
public class GrpcChannelSupplierPropertiesBase implements GrpcChannelSupplierProperties {
    private List<String> targets;

    @Valid
    private YpDiscoveryProperties yp;

    @Valid
    @NotNull
    private GrpcChannelSupplierMode mode;

    @Valid
    private FailureDetectorProperties failureDetection;

    @NotNull
    private Duration timeout;

    private GrpcChannelSupplierTvmProperties tvm;

    private boolean forwardUserCredentials;
}
