package ru.yandex.travel.orders.client;

public interface ChannelConsumer {
    /**
     * Is called once a channel is discovered. May be called multiple times,
     * once in a while while the channel is still present.
     * Such subsequent calls should be idempotent.
     *
     * Reference implementation should cache received channel in a set or a map and
     * ignore subsequent calls if the channel is already present.
     *
     * @param channelLabel label (or 'target') of discovered grpc channel
     */
    void onChannelDiscovered(String channelLabel);

    /**
     * Is called exactly once when the channel which was previously known to supplier
     * is no longer discoverable. When the channel becomes discoverable again a new
     * call to {@link #onChannelDiscovered} will be made.
     *
     * Reference implementation should evict previously discovered channels from its
     * set/map, while being prepared that the channel with such label will not be found.
     *
     * @param channelLabel label identifying the labeled channel being lost
     */
    void onChannelLost(String channelLabel);
}
