package ru.yandex.travel.orders.client;

import java.time.Instant;

import io.grpc.Channel;

public class ChannelInfo {
    private final String label; // for logging purposes
    private final Channel channel;
    private final StatefulPhiAccrualFailureDetector failureDetector;


    public ChannelInfo(String label, Channel channel, StatefulPhiAccrualFailureDetector failureDetector) {
        this.label = label;
        this.channel = channel;
        this.failureDetector = failureDetector;
    }

    public boolean isMaster() {
        return failureDetector.isMaster(System.currentTimeMillis());
    }

    public boolean isMaster(Instant at) {
        return failureDetector.isMaster(at.toEpochMilli());
    }

    public boolean isReady() {
        return failureDetector.isReady(System.currentTimeMillis());
    }

    public boolean isReady(Instant at) {
        return failureDetector.isReady(at.toEpochMilli());
    }

    public double getAverageLatency() {
        return failureDetector.getAverageLatency();
    }

    public void heartbeat(ChannelState state) {
        failureDetector.heartbeat(System.currentTimeMillis(), state);
    }

    public Channel getChannel() {
        return channel;
    }

    public String getLabel() {
        return label;
    }
}
