package ru.yandex.travel.orders.client;


import java.util.concurrent.ConcurrentLinkedQueue;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@RequiredArgsConstructor
@Slf4j
public abstract class ChannelSupplier {
    private final ConcurrentLinkedQueue<ChannelConsumer> consumers = new ConcurrentLinkedQueue<>();

    public void subscribe(ChannelConsumer consumer) {
        consumers.add(consumer);
    }

    protected void onChannelDiscovered(String channelLabel) {
        log.debug("Discovered channel: " + channelLabel);
        consumers.forEach(consumer -> consumer.onChannelDiscovered(channelLabel));
    }

    protected void onChannelLost(String channelLabel) {
        log.warn("Lost channel: " + channelLabel);
        consumers.forEach(consumer -> consumer.onChannelLost(channelLabel));
    }

}
