package ru.yandex.travel.orders.client;

import java.util.List;

import com.google.common.base.Preconditions;

public class FixedListChannelSupplier extends ChannelSupplier {
    private final List<String> channelList;

    public FixedListChannelSupplier(List<String> targets) {
        Preconditions.checkArgument(!targets.isEmpty(), "Channel list should not be empty");
        channelList = targets;
    }

    @Override
    public void subscribe(ChannelConsumer consumer) {
        super.subscribe(consumer);
        channelList.forEach(consumer::onChannelDiscovered);
    }
}
