package ru.yandex.travel.orders.client;


import java.util.ArrayList;
import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@RequiredArgsConstructor
@Slf4j
public class MultipleChannelSupplier extends ChannelSupplier {
    private final List<ChannelSupplier> suppliers = new ArrayList<>();

    public void addSupplier(ChannelSupplier supplier) {
        suppliers.add(supplier);
    }

    public void subscribe(ChannelConsumer consumer) {
        for (ChannelSupplier supplier: suppliers) {
            supplier.subscribe(consumer);
        }
    }
}
