package ru.yandex.travel.orders.client.yp;

import java.text.MessageFormat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@AllArgsConstructor
@NoArgsConstructor
@Setter
@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
public class Endpoint {
    @EqualsAndHashCode.Include
    private String id;
    private String host;
    private Integer port;

    public static Endpoint fromTarget(String target) {
        var parts = target.split(":");
        Preconditions.checkArgument(parts.length == 2);
        return new Endpoint(target, parts[0], Integer.valueOf(parts[1]));
    }

    @JsonIgnore
    public String getTarget() {
        return MessageFormat.format("{0}:{1}", host, String.valueOf(port));
    }
}
