package ru.yandex.travel.hibernate.dialects;

import org.hibernate.dialect.H2Dialect;

import java.sql.Types;

/**
 * Custom H2 Dialect registering to custom types for use with jsonb and json
 */
public class CustomH2Dialect extends H2Dialect {
    public CustomH2Dialect() {
        super();
        registerColumnType(Types.JAVA_OBJECT, "OTHER");
        registerColumnType(Types.JAVA_OBJECT - 1, "OTHER");
        registerColumnType(Types.BLOB, "varbinary" );
        registerColumnType( Types.TINYINT, "smallint" );
    }
}
