package ru.yandex.travel.hibernate.types;

import com.google.protobuf.Message;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProtobufUtils {

    @SuppressWarnings("unchecked")
    public static <TB extends Message.Builder> TB newBuilderForMessage(Class<? extends Message> type)
            throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (TB) getMethod(type, "newBuilder").invoke(null);
    }

    @SuppressWarnings("unchecked")
    public static <T extends Message> T parseFrom(Class<? extends Message> type, byte[] source) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return (T) getMethod(type, "parseFrom", new Class[]{byte[].class}).invoke(null, source);
    }

    private static Method getMethod(Class<?> type, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method m = type.getDeclaredMethod(methodName, parameterTypes);
        m.setAccessible(true);
        return m;
    }

    private static Method getMethod(Class<?> type, String methodName) throws NoSuchMethodException {
        return getMethod(type, methodName, new Class<?>[0]);
    }

}
