package ru.yandex.travel.commons.jackson;

import java.io.IOException;
import java.math.BigDecimal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.javamoney.moneta.Money;

public class MoneyDeserializer extends StdDeserializer<Money> {

    public MoneyDeserializer() {
        this(null);
    }

    public MoneyDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public Money deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = p.getCodec();
        JsonNode moneyNode = oc.readTree(p);
        return fromNode(moneyNode);
    }

    public Money fromNode(JsonNode node) {
        BigDecimal value;
        JsonNode valueNode = node.get("value");
        if (valueNode == null) {
            valueNode = node.get("amount");
            value = BigDecimal.valueOf(Double.parseDouble(valueNode.textValue()));
        } else {
            value = valueNode.decimalValue();
        }
        String currency = node.get("currency").textValue();
        return Money.of(value, currency);
    }
}
