package ru.yandex.travel.commons.jackson;

import java.io.IOException;
import java.math.BigDecimal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.javamoney.moneta.Money;

public class MoneySerializer extends StdSerializer<Money> {
    public MoneySerializer() {
        this(null);
    }

    public MoneySerializer(Class<Money> t) {
        super(t);
    }

    @Override
    public void serialize(Money value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("value", value.getNumber().numberValue(BigDecimal.class));
        gen.writeStringField("currency", value.getCurrency().getCurrencyCode());
        gen.writeEndObject();
    }
}
