package ru.yandex.travel.commons.logging.ydb;

import com.google.common.base.Strings;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.slf4j.MDC;

import static ru.yandex.travel.commons.logging.CommonMdcParams.MDC_ENTITY_ID;

@Plugin(name = "YdbLogFilter", category = Node.CATEGORY, elementType = Filter.ELEMENT_TYPE)
public class YdbLogFilter extends AbstractFilter {
    @Override
    public Result filter(final Logger logger, final Level level, final Marker marker, final String msg,
                         final Object... params) {
        return filterImpl(MDC.get(MDC_ENTITY_ID));
    }

    @Override
    public Result filter(final Logger logger, final Level level, final Marker marker, final Object msg,
                         final Throwable t) {
        return filterImpl(MDC.get(MDC_ENTITY_ID));
    }

    @Override
    public Result filter(final Logger logger, final Level level, final Marker marker, final Message msg,
                         final Throwable t) {
        return filterImpl(MDC.get(MDC_ENTITY_ID));
    }

    @Override
    public Result filter(final LogEvent event) {
        return filterImpl(event.getContextData().getValue(MDC_ENTITY_ID));
    }

    private Result filterImpl(Object ctxEntityId) {
        return ctxEntityId instanceof String && !Strings.isNullOrEmpty((String) ctxEntityId) ? Result.ACCEPT : Result.DENY;
    }

    @PluginFactory
    public static YdbLogFilter createFilter() {
        return new YdbLogFilter();
    }
}
