package ru.yandex.travel.commons.logging.ydb;

import java.util.ArrayList;
import java.util.Collection;

import com.yandex.ydb.core.auth.AuthProvider;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.rpc.TableRpc;
import com.yandex.ydb.table.rpc.grpc.GrpcTableRpc;
import org.apache.logging.log4j.core.appender.ManagerFactory;

public class YdbLogManagerFactory implements ManagerFactory<YdbLogManager, YdbLogProperties> {
    @Override
    public YdbLogManager createManager(String name, YdbLogProperties properties) {
        Collection<AutoCloseable> closableResources = new ArrayList<>();
        try {
            AuthProvider authProvider = createTvmAuthProvider(properties);
            closableResources.add(authProvider);
            RpcTransport transport = createTransport(authProvider, properties);
            closableResources.add(transport);
            TableRpc tableRpc = GrpcTableRpc.ownTransport(transport);
            closableResources.add(tableRpc);
            TableClient tableClient = TableClient.newClient(tableRpc).build();
            closableResources.add(tableClient);
            return new YdbLogManager(name, new YdbLogTableClient(
                    authProvider,
                    tableClient,
                    properties.getTablePath(),
                    properties.getClientTimeout(),
                    properties.getMaxAttempts(),
                    properties.getBackoffSlot(),
                    properties.getBackoffCeiling()
            ), properties);
        } catch (Exception e) {
            for (AutoCloseable resource : closableResources) {
                try {
                    resource.close();
                } catch (Exception ne) {
                    e.addSuppressed(ne);
                }
            }
            throw e;
        }
    }

    private static AuthProvider createTvmAuthProvider(YdbLogProperties properties) {
        return YdbLogTvmAuthContext.tvmAuthProvider(properties.getTvmClientId(), properties.getTvmSecret());
    }

    private static RpcTransport createTransport(AuthProvider authProvider, YdbLogProperties properties) {
        return GrpcTransport.forEndpoint(properties.getDbEndpoint(), properties.getDbPath())
                .withAuthProvider(authProvider)
                .withReadTimeout(properties.getClientTimeout())
                .build();
    }
}
