package ru.yandex.travel.commons.logging.ydb;

import java.time.Duration;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.ToString;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ToString(exclude = "tvmSecret")
public class YdbLogProperties {
    @NonNull
    private String dbEndpoint;
    @NonNull
    private String dbPath;
    @NonNull
    private String tablePath;
    private int tvmClientId;
    @NonNull
    private String tvmSecret;
    private int queueSize;
    private int batchSize;
    private int maxAttempts;
    @NonNull
    private Duration clientTimeout;
    @NonNull
    private Duration backoffSlot;
    private int backoffCeiling;
    @NonNull
    private Duration shutdownTimeout;
}
