package ru.yandex.travel.commons.logging.ydb;

import java.util.List;

import com.yandex.ydb.auth.tvm.YdbClientId;
import com.yandex.ydb.core.auth.AuthProvider;

import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.TvmClientCredentials;

// the source version of TvmAuthContext doesn't close the tvm working thread (something wrong with TvmClient)
public class YdbLogTvmAuthContext {
    public static AuthProvider tvmAuthProvider(int selfClientId, String selfSecret) {
        Tvm2 tvm = new Tvm2(new TvmClientCredentials(selfClientId, selfSecret));
        tvm.addDstClientIds(List.of(YdbClientId.YDB.getId()));
        tvm.start();
        return new AuthProvider() {
            @Override
            public String getToken() {
                return tvm.getServiceTicket(YdbClientId.YDB.getId())
                        .getOrThrow("Failed to get tvm ticket for YDB");
            }

            @Override
            public void close() {
                tvm.stop();
            }
        };
    }
}
