package ru.yandex.travel.commons.logging.ydb.backup;

import java.nio.charset.Charset;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;

import ru.yandex.travel.commons.logging.ydb.YdbLogRecordFactory;
import ru.yandex.travel.commons.network.NetworkUtils;
import ru.yandex.travel.commons.proto.ProtoJsonConverter;
import ru.yandex.travel.logging.ydb.TOrderLogRecord;

@Plugin(name = "YdbLogJsonLayout", category = Node.CATEGORY, elementType = Layout.ELEMENT_TYPE, printObject = true)
@SuppressWarnings("unused")
public class YdbLogJsonLayout extends AbstractStringLayout {
    private final YdbLogRecordFactory logRecordFactory;

    protected YdbLogJsonLayout() {
        super(Charset.defaultCharset());
        this.logRecordFactory = new YdbLogRecordFactory(NetworkUtils.getLocalHostName());
    }

    @PluginFactory
    public static Layout<String> createLayout() {
        return new YdbLogJsonLayout();
    }

    @Override
    public String toSerializable(LogEvent event) {
        TOrderLogRecord logRecord = logRecordFactory.createFromLogEvent(event);
        return ProtoJsonConverter.toJson(logRecord) + "\n";
    }
}
