/**
 * The package provides components that allow logging of application messages into YDB.
 *
 * <p>Main components are: {@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogTableClient}
 * and {@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogAppender}.
 *
 * <p>{@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogTableClient} is a client to YDB
 * that hides all connecting and transactional writing logic inside.
 * It does its best to silently re-connect in case temporary failures
 * and complete the message delivery operation in a few re-tries.
 * If it fails to do so a runtime exception is thrown and the log message is lost.
 *
 * <p>{@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogAppender} is an implementation
 * of the log4j2 Appender interface that connects all necessary loggers to the ydb log client. It uses
 * the other log4j2-related components as follows:
 * <ul>
 * <li>{@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogAppender#createAppender}
 * is a factory method and the entry point that initializes all dependent components.
 * It uses the standard manager factory mechanism and {@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogManagerFactory}
 * to obtain an instance of {@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogManager}.
 * <li>{@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogManager} is a manager that holds
 * resources (db client) and does actual logging.
 * It receives filtered log events from YdbLogAppender, converts and sends them to YdbLogTableClient.
 * It doesn't do any re-tries on errors and doesn't manage YDB transactions.
 * This part implements async events batching and processing.
 * <li>{@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogProperties} is used to pass parameters
 * from the log4j2.xml config to the manager factory.
 * Note that we can't rely on our Spring-based configs here as there is no Spring context at the initialization phase yet.
 * </ul>
 * <p>(We also use our own {@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogTvmAuthContext}
 * implementation to overcome problems with TvmClient)
 *
 * <p>Because YdbLogTableClient's network related logic can cause high latency
 * and shouldn't be used directly from application code, {@linkplain ru.yandex.travel.commons.logging.ydb.YdbLogManager}
 * uses a blocking queue for all incoming messages and a separate processing thread that
 * batches available events and passes the batches into YdbLogTableClient.
 * Its queueSize and batchSize parameters should be chosen with care: if the queue if full all new message are dropped.
 *
 * <p>A service that uses this appender via an async queue should monitor the following parameters:
 * queued events amount, actual sizes of batches, write duration.
 */
package ru.yandex.travel.commons.logging.ydb;
