PEERDIR(
    contrib/java/org/projectlombok/lombok/1.18.22
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
)

JAVAC_FLAGS(
    # Lombok frequently causes StackOverflowErrors on project building via the ya make tool.
    # IDEA developers suggested increasing the stack size (https://youtrack.jetbrains.com/issue/IDEA-174764).
    # The advice actually helps: with -J-Xss512k we permanently get the well-known error:
    # 	    at lombok.javac.JavacAST.buildStatementOrExpression(JavacAST.java:392)
    #  	    at lombok.javac.JavacAST.buildTree(JavacAST.java:201)
    # 	    at lombok.javac.JavacAST.buildTree(JavacAST.java:1)
    # 	    at lombok.core.AST.buildWithField0(AST.java:394)
    # 	    at lombok.core.AST.buildWithField(AST.java:292)
    # 	    at lombok.javac.JavacAST.drill(JavacAST.java:426)
    # while using -J-Xss16m overcomes the problem.
    # (tested with 'ya make hotels/lib/java/partner_parsers/')
    # Xss512k is close to the default values, for more details on this option check the Xss paragraph here:
    #       https://docs.oracle.com/cd/E13150_01/jrockit_jvm/jrockit/jrdocs/refman/optionX.html
    -J-Xss16m
)
