package ru.yandex.travel.workflow.ha;

public class LockState {
    private final boolean isAcquired;
    private final long changedAt;

    private LockState(boolean isAcquired, long changedAt) {
        this.isAcquired = isAcquired;
        this.changedAt = changedAt;
    }

    public long timeSinceLost() {
        return isAcquired ? 0 : System.currentTimeMillis() - changedAt;
    }

    public long timeSinceAcquired() {
        return isAcquired ? System.currentTimeMillis() - changedAt : 0;
    }

    public static LockState acquired() {
        return new LockState(true, System.currentTimeMillis());
    }

    public static LockState lost() {
        return new LockState(false, System.currentTimeMillis());
    }

    public boolean isAcquired() {
        return isAcquired;
    }
}
