package ru.yandex.travel.natives;

import com.sun.jna.Native;
import lombok.extern.slf4j.Slf4j;

@Slf4j
final class JNACLibrary {

    static final int MCL_CURRENT = 1;
    static final int MCL_FUTURE = 1;

    static {
        try {
            Native.register("c");
        } catch (UnsatisfiedLinkError e) {
            log.error("Unable to link C library. native methods (mlockall) will be disabled", e);
        }
    }

    static native int mlockall(int flags);
}
