package ru.yandex.travel.natives;

import lombok.extern.slf4j.Slf4j;

// partial copy of elasticsearch code
@Slf4j
public class Natives {
    private Natives() {
    }

    // marker to determine if the JNA class files are available to the JVM
    private static final boolean JNA_AVAILABLE;

    static {
        boolean v = false;
        try {
            // load one of the main JNA classes to see if the classes are available. this does not ensure that all
            // native
            // libraries are available, only the ones necessary by JNA to function
            Class.forName("com.sun.jna.Native");
            v = true;
        } catch (ClassNotFoundException e) {
            log.warn("JNA not found. native methods will be disabled", e);
        } catch (UnsatisfiedLinkError e) {
            log.warn("Unable to load JNA native support library, native methods will be disabled", e);
        }
        JNA_AVAILABLE = v;
    }

    public static void tryMlockall() {
        if (!JNA_AVAILABLE) {
            log.error("Cannot mlockall because JNA is not available");
            return;
        }
        JNANatives.tryMlockall();
    }
}
