package ru.yandex.travel.hotels.services.promoservice;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.proto.TCalculateDiscountForOfferReq;
import ru.yandex.travel.hotels.proto.TCalculateDiscountForOfferRsp;
import ru.yandex.travel.hotels.proto.TDeterminePromosForOfferReq;
import ru.yandex.travel.hotels.proto.TDeterminePromosForOfferRsp;
import ru.yandex.travel.hotels.proto.TExperimentInfo;
import ru.yandex.travel.hotels.proto.TGetActivePromosReq;
import ru.yandex.travel.hotels.proto.TGetActivePromosRsp;
import ru.yandex.travel.hotels.proto.TGetWhiteLabelPointsPropsReq;
import ru.yandex.travel.hotels.proto.TGetWhiteLabelPointsPropsRsp;
import ru.yandex.travel.hotels.proto.TOfferInfo;
import ru.yandex.travel.hotels.proto.TUserInfo;
import ru.yandex.travel.hotels.proto.TWhiteLabelInfo;
import ru.yandex.travel.white_label.proto.EWhiteLabelPointsType;

public interface PromoServiceClient {
    CompletableFuture<TDeterminePromosForOfferRsp> determinePromosForOffer(TDeterminePromosForOfferReq req);

    CompletableFuture<TDeterminePromosForOfferRsp> determinePromosForOffer(TOfferInfo offerInfo,
                                                                           TUserInfo userInfo,
                                                                           TExperimentInfo experimentInfo,
                                                                           TWhiteLabelInfo whiteLabelInfo);

    CompletableFuture<TGetActivePromosRsp> getActivePromos(TGetActivePromosReq req);

    CompletableFuture<TGetActivePromosRsp> getActivePromos(Instant now);

    CompletableFuture<TCalculateDiscountForOfferRsp> calculateDiscountForOffer(TCalculateDiscountForOfferReq req);

    CompletableFuture<TCalculateDiscountForOfferRsp> calculateDiscountForOffer(TOfferInfo offerInfo,
                                                                               TUserInfo userInfo,
                                                                               TExperimentInfo experimentInfo);

    CompletableFuture<TGetWhiteLabelPointsPropsRsp> getWhiteLabelPointsProps(TGetWhiteLabelPointsPropsReq req);

    CompletableFuture<TGetWhiteLabelPointsPropsRsp> getWhiteLabelPointsProps(EWhiteLabelPointsType pointsType,
                                                                             int Amount);
}
