package ru.yandex.travel.hotels.services.promoservice;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

import lombok.Value;
import org.springframework.stereotype.Service;

import ru.yandex.travel.commons.concurrent.FutureUtils;
import ru.yandex.travel.commons.proto.ProtoUtils;
import ru.yandex.travel.hotels.proto.TCalculateDiscountForOfferReq;
import ru.yandex.travel.hotels.proto.TCalculateDiscountForOfferRsp;
import ru.yandex.travel.hotels.proto.TDeterminePromosForOfferReq;
import ru.yandex.travel.hotels.proto.TDeterminePromosForOfferRsp;
import ru.yandex.travel.hotels.proto.TExperimentInfo;
import ru.yandex.travel.hotels.proto.TGetActivePromosReq;
import ru.yandex.travel.hotels.proto.TGetActivePromosRsp;
import ru.yandex.travel.hotels.proto.TGetWhiteLabelPointsPropsReq;
import ru.yandex.travel.hotels.proto.TGetWhiteLabelPointsPropsRsp;
import ru.yandex.travel.hotels.proto.TOfferInfo;
import ru.yandex.travel.hotels.proto.TUserInfo;
import ru.yandex.travel.hotels.proto.TWhiteLabelInfo;
import ru.yandex.travel.white_label.proto.EWhiteLabelPointsType;


@Value
@Service
public class PromoServiceClientImpl implements PromoServiceClient {
    private final PromoServiceClientFactory clientFactory;
    private final Clock clock;

    @Override
    public CompletableFuture<TDeterminePromosForOfferRsp> determinePromosForOffer(TDeterminePromosForOfferReq req) {
        return FutureUtils.buildCompletableFuture(clientFactory.createFutureStub().determinePromosForOffer(req));
    }

    @Override
    public CompletableFuture<TDeterminePromosForOfferRsp> determinePromosForOffer(
            TOfferInfo offerInfo,
            TUserInfo userInfo,
            TExperimentInfo experimentInfo,
            TWhiteLabelInfo whiteLabelInfo
    ) {
        return determinePromosForOffer(TDeterminePromosForOfferReq.newBuilder()
                .setNow(ProtoUtils.fromInstant(Instant.now(clock)))
                .setOfferInfo(offerInfo)
                .setUserInfo(userInfo)
                .setExperimentInfo(experimentInfo)
                .setWhiteLabelInfo(whiteLabelInfo)
                .build());
    }

    @Override
    public CompletableFuture<TGetActivePromosRsp> getActivePromos(TGetActivePromosReq req) {
        return FutureUtils.buildCompletableFuture(clientFactory.createFutureStub().getActivePromos(req));
    }

    @Override
    public CompletableFuture<TGetActivePromosRsp> getActivePromos(Instant now) {
        return getActivePromos(TGetActivePromosReq.newBuilder()
                .setNow(ProtoUtils.fromInstant(now))
                .build());
    }

    @Override
    public CompletableFuture<TCalculateDiscountForOfferRsp> calculateDiscountForOffer(TCalculateDiscountForOfferReq req) {
        return FutureUtils.buildCompletableFuture(clientFactory.createFutureStub().calculateDiscountForOffer(req));
    }

    @Override
    public CompletableFuture<TCalculateDiscountForOfferRsp> calculateDiscountForOffer(
            TOfferInfo offerInfo,
            TUserInfo userInfo,
            TExperimentInfo experimentInfo
    ) {
        return calculateDiscountForOffer(TCalculateDiscountForOfferReq.newBuilder()
                .setNow(ProtoUtils.fromInstant(Instant.now(clock)))
                .setOfferInfo(offerInfo)
                .setUserInfo(userInfo)
                .setExperimentInfo(experimentInfo)
                .build());
    }

    @Override
    public CompletableFuture<TGetWhiteLabelPointsPropsRsp> getWhiteLabelPointsProps(TGetWhiteLabelPointsPropsReq req) {
        return FutureUtils.buildCompletableFuture(clientFactory.createFutureStub().getWhiteLabelPointsProps(req));
    }

    @Override
    public CompletableFuture<TGetWhiteLabelPointsPropsRsp> getWhiteLabelPointsProps(EWhiteLabelPointsType pointsType,
                                                                                    int amount) {
        return getWhiteLabelPointsProps(TGetWhiteLabelPointsPropsReq.newBuilder()
                .setPointsType(pointsType)
                .setAmount(amount)
                .build());
    }
}
