package ru.yandex.travel.integration.spark;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import ru.yandex.travel.commons.http.apiclient.HttpApiPropertiesBase;

@Getter
@Setter
@NoArgsConstructor
public class SparkClientProperties extends HttpApiPropertiesBase {

    @NotNull
    private Duration sessionTtl;

    @NotEmpty
    private String login;

    @NotEmpty
    private String password;

    @Builder
    public SparkClientProperties(@NotEmpty String baseUrl, @NotNull Duration httpReadTimeout,
                                 @NotNull Duration httpRequestTimeout, Duration sessionTtl, @NotEmpty String login,
                                 @NotEmpty String password) {
        super(baseUrl, httpReadTimeout, httpRequestTimeout);
        this.sessionTtl = sessionTtl;
        this.login = login;
        this.password = password;
    }

}
