RECURSE_FOR_TESTS(
    src/test
)

JAVA_LIBRARY()

JDK_VERSION(11)

OWNER(g:travel)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)
JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*)

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

PEERDIR(
    travel/library/java/commons

    contrib/java/org/asynchttpclient/async-http-client
    contrib/java/com/sun/xml/ws/jaxws-ri
    contrib/java/javax/xml/bind/jaxb-api
)

SET(
    WSIMPORT_ARGS
    -keep -s ${BINDIR}/generated
    -p ru.yandex.travel.integration.spark.model
    -Xnocompile
    -B-Xsetters -B-Xsetters-mode=direct
    -B-XReplacePrimitives
    -B-XJsr303Annotations
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/schema.wsdl
    IN src/main/resources/schema.wsdl
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

# Added automatically to remove dependency on default contrib versions
DEPENDENCY_MANAGEMENT(
    contrib/java/com/sun/xml/ws/jaxws-ri/2.3.0
)

LINT(base)
END()
