package ru.yandex.travel.actuator;

import io.micrometer.core.instrument.Metrics;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.Status;

public class HealthCheckMeterHost {

    private final HealthEndpoint healthEndpoint;

    public HealthCheckMeterHost(HealthEndpoint healthEndpoint) {
        this.healthEndpoint = healthEndpoint;
        Metrics.gauge("service.aliveServers", this, HealthCheckMeterHost::check);
    }

    private double check() {
        return healthEndpoint.health().getStatus() == Status.UP ? 1 : 0;
    }
}
