package ru.yandex.travel.actuator;

import java.time.Duration;
import java.util.Arrays;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.metrics.MetricsUtils;

@Configuration
@AutoConfigureBefore({MetricsAutoConfiguration.class,
        CompositeMeterRegistryAutoConfiguration.class,
        SimpleMetricsExportAutoConfiguration.class})
public class MeterCustomizerAutoConfiguration {
    private static final Duration[] GC_SLA = {
            Duration.ofMillis(1), Duration.ofMillis(10), Duration.ofMillis(50),
            Duration.ofMillis(100), Duration.ofMillis(200), Duration.ofMillis(300), Duration.ofMillis(400),
            Duration.ofMillis(500),
            Duration.ofMillis(1000), Duration.ofMillis(5000), Duration.ofMillis(10000),
            Duration.ofMillis(100000)
    };

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> jvmGcMeterRegistryCustomizer() {
        return registry -> {
            registry.config().meterFilter(new MeterFilter() {
                @Override
                public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                    if (id.getName().startsWith("jvm.gc.pause")
                            || id.getName().startsWith("jvm.gc.concurrent.phase.time")) {
                        return DistributionStatisticConfig.builder()
                                .serviceLevelObjectives(Arrays.stream(GC_SLA).mapToDouble(Duration::toNanos).toArray())
                                .percentilesHistogram(true)
                                .percentiles(MetricsUtils.higherPercentiles())
                                .build();
                    } else {
                        return config;
                    }
                }
            });
        };
    }
}
