package ru.yandex.travel.actuator;

import com.google.common.net.HttpHeaders;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;

@Controller
@WebEndpoint(id = "solomon")
public class SolomonEndpoint {
    @Value("${solomon.format:spack}")
    private String defaultFormat;

    private final MeterRegistry meterRegistry;

    SolomonEndpoint(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @ReadOperation
    public ResponseEntity<byte[]> scrape(@Nullable String format) {
        if (format == null) {
            format = defaultFormat;
        }
        if (format.equals("json")) {
            var resp = MicrometerToSolomonEncoder.encodeJson(meterRegistry);
            return ResponseEntity.ok()
                    .header(HttpHeaders.CONTENT_TYPE, ContentType.APPLICATION_JSON.getMimeType())
                    .body(resp);
        } else if (format.equals("spack")) {
            var resp = MicrometerToSolomonEncoder.encodeSpack(meterRegistry);
            return ResponseEntity.ok()
                    .header(HttpHeaders.CONTENT_TYPE, "application/x-solomon-spack")
                    .body(resp);
        } else {
            return ResponseEntity.badRequest().body(("Unknown format: '" + format + "'").getBytes());
        }
    }
}
