package ru.yandex.travel.actuator;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter({
        MetricsAutoConfiguration.class,
        CompositeMeterRegistryAutoConfiguration.class,
        SimpleMetricsExportAutoConfiguration.class})
public class SolomonEndpointAutoConfiguration {
    @Bean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnMissingBean
    public SolomonEndpoint solomonEndpoint(MeterRegistry meterRegistry) {
        return new SolomonEndpoint(meterRegistry);
    }

    @Bean
    public HealthCheckMeterHost HealthCheckMeterHost(HealthEndpoint healthEndpoint) {
        return new HealthCheckMeterHost(healthEndpoint);
    }
}
