package ru.yandex.travel.credentials;

import java.text.MessageFormat;

import com.google.common.base.Strings;
import io.grpc.Context;
import lombok.Builder;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Builder
public class UserCredentials {
    public final static Context.Key<UserCredentials> KEY = Context.key("USER_CREDENTIALS");

    @Getter
    private final String sessionKey;
    @Getter
    private final String yandexUid;
    @Getter
    private final String passportId;
    @Getter
    private final String login;
    @Getter
    private final String userTicket;
    @Getter
    private final String userIp;
    @Getter
    private final boolean userIsStaff;
    @Getter
    private final boolean userIsPlus;

    public static UserCredentials get() {
        return KEY.get();
    }

    public boolean isLoggedIn() {
        return passportId != null;
    }

    public Long getParsedPassportIdOrNull() {
        if (!Strings.isNullOrEmpty(passportId)) {
            return Long.parseLong(passportId);
        } else {
            return null;
        }
    }

    @Override
    public String toString() {
        if (isLoggedIn()) {
            return MessageFormat.format("{0} (PassportId={1}, YandexUid={2}, UserIp={3})", login != null ? login :
                            "<unknown>",
                    passportId, yandexUid, userIp);
        } else {
            return MessageFormat.format("<anonymous> (YandexUid={0}, UserIp={1})", yandexUid, userIp);
        }
    }
}
