package ru.yandex.travel.credentials;

import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.travel.tvm.TvmWrapper;
import ru.yandex.travel.tvm.UserTicketCheck;

@RequiredArgsConstructor
public class UserCredentialsAuthValidatorTvmImpl implements UserCredentialsAuthValidator {
    @NonNull
    private final TvmWrapper tvm;

    @Override
    public UserCredentialsAuthValidationResult validate(String passportIdValue, String login, String userTicket) {
        if ((StringUtils.isNotBlank(passportIdValue) || StringUtils.isNotBlank(login)) && StringUtils.isBlank(userTicket)) {
            return UserCredentialsAuthValidationResult.invalid("Missing user ticket");
        }

        Long passportId = null;
        if (StringUtils.isNotBlank(passportIdValue)) {
            try {
                passportId = Long.parseLong(passportIdValue);
            } catch (NumberFormatException ignored) {
                return UserCredentialsAuthValidationResult.invalid("Invalid passport id");
            }
        }

        if (StringUtils.isNotBlank(userTicket)) {
            UserTicketCheck ticketCheck = tvm.checkUserTicket(userTicket, passportId);
            if (!ticketCheck.isOk()) {
                return UserCredentialsAuthValidationResult.invalid(ticketCheck.getDescription());
            }
        }

        return UserCredentialsAuthValidationResult.OK;
    }
}
