package ru.yandex.travel.credentials;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

import ru.yandex.travel.tvm.TvmWrapper;

@Configuration
@EnableConfigurationProperties(UserCredentialsProperties.class)
@ConditionalOnProperty("credentials.enabled")
public class UserCredentialsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(UserCredentialsAuthValidator.class)
    @ConditionalOnProperty("credentials.auth-enabled")
    public UserCredentialsAuthValidator credentialsValidator(TvmWrapper tvm) {
        return new UserCredentialsAuthValidatorTvmImpl(tvm);
    }

    @Bean
    @ConditionalOnMissingBean(UserCredentialsAuthValidator.class)
    @ConditionalOnProperty(value = "credentials.auth-enabled", havingValue = "false")
    public UserCredentialsAuthValidator credentialsValidatorStub() {
        return new UserCredentialsAuthValidatorStubImpl();
    }

    @Bean
    @ConditionalOnMissingBean(UserCredentialsPassportExtractor.class)
    @ConditionalOnProperty("credentials.auth-enabled")
    public UserCredentialsPassportExtractor credentialsPassportExtractor(TvmWrapper tvm) {
        return new UserCredentialsPassportExtractorTvmImpl(tvm);
    }

    @Bean
    @ConditionalOnMissingBean(UserCredentialsPassportExtractor.class)
    @ConditionalOnProperty(value = "credentials.auth-enabled", havingValue = "false")
    public UserCredentialsPassportExtractor credentialsPassportExtractorStub() {
        return new UserCredentialsPassportExtractorStubImpl();
    }

    @Bean
    @ConditionalOnMissingBean(UserCredentialsValidationHandlerInterceptor.class)
    @ConditionalOnProperty("credentials.enabled")
    @Order(500)
    public UserCredentialsValidationHandlerInterceptor userCredentialsMvcHandlerInterceptor(UserCredentialsAuthValidator validator) {
        return new UserCredentialsValidationHandlerInterceptor(new UserCredentialsValidator(validator));
    }

    @Bean
    @ConditionalOnMissingBean(UserLoggedInHandlerInterceptor.class)
    @Order(1000) // it must be used after user credentials mvc handler
    public UserLoggedInHandlerInterceptor userLoggedInHandlerInterceptor() {
        return new UserLoggedInHandlerInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(UserCredentialsBuilder.class)
    public UserCredentialsBuilder userCredentialsBuilder() {
        return new UserCredentialsBuilder();
    }

}
