package ru.yandex.travel.credentials;

import com.google.common.base.Strings;

import ru.yandex.misc.lang.StringUtils;

public class UserCredentialsBuilder {

    public UserCredentials build(String sessionKey, String yandexUid, String passportIdValue, String login,
                                 String userTicket, String userIp, boolean userIsStaff, boolean userIsPlus)
            throws BadUserCredentialsException {
        if (Strings.isNullOrEmpty(passportIdValue)) {
            passportIdValue = null;
        }

        if (StringUtils.isBlank(userIp)) {
            userIp = "127.0.0.1";
        }
        return new UserCredentials(sessionKey, yandexUid, passportIdValue, login, userTicket, userIp, userIsStaff,
                userIsPlus);
    }
}
