package ru.yandex.travel.credentials;

import com.google.common.base.Strings;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.tvm.TvmWrapper;
import ru.yandex.travel.tvm.UserTicketCheck;

@RequiredArgsConstructor
@Slf4j
public class UserCredentialsPassportExtractorTvmImpl implements UserCredentialsPassportExtractor {
    private final TvmWrapper tvm;

    @Override
    public String extractPassportId(String passportId, String userTicket) {
        if (Strings.isNullOrEmpty(passportId)) {
            UserTicketCheck ticketCheck = tvm.checkUserTicket(userTicket, null);
            if (ticketCheck.isOk()) {
                log.warn("No passport id has been passed; replacing it with the default uid from the user ticket: {}", ticketCheck.getDefaultUid());
                return String.valueOf(ticketCheck.getDefaultUid());
            } else {
                return null;
            }
        }
        return passportId;
    }
}
