package ru.yandex.travel.credentials;

import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.servlet.HandlerInterceptor;

@RequiredArgsConstructor
@Slf4j
public class UserCredentialsValidationHandlerInterceptor implements HandlerInterceptor {
    private final UserCredentialsValidator credentialsValidator;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        // checking credentials for other dispatchers is not safe
        // e.g. ASYNC dispatcher loses UserCredentials set inside the filter
        if (request.getDispatcherType() == DispatcherType.REQUEST) {
            UserCredentials userCredentials = UserCredentials.get();
            try {
                credentialsValidator.validate(userCredentials);
            } catch (BadUserCredentialsException e) {
                log.error("User credentials validation has failed: {}", e.getMessage());
                throw new UnauthenticatedUserException(e.getMessage());
            }
        }
        return true;
    }
}
