package ru.yandex.travel.credentials;

import org.apache.commons.lang3.StringUtils;

public class UserCredentialsValidator {
    private final UserCredentialsAuthValidator authValidator;

    private final boolean requireYandexUid;

    public UserCredentialsValidator(UserCredentialsAuthValidator authValidator) {
        this.authValidator = authValidator;
        this.requireYandexUid = true;
    }

    public UserCredentialsValidator(UserCredentialsAuthValidator authValidator, boolean requireYandexUid) {
        this.authValidator = authValidator;
        this.requireYandexUid = requireYandexUid;
    }

    public void validate(UserCredentials userCredentials) throws BadUserCredentialsException {
        if (userCredentials == null) {
            throw new BadUserCredentialsException("Missing user credentials");
        }
        if (requireYandexUid && StringUtils.isBlank(userCredentials.getYandexUid())) {
            throw new BadUserCredentialsException("Missing yandex uid");
        }
        if (StringUtils.isBlank(userCredentials.getSessionKey()) && StringUtils.isBlank(userCredentials.getPassportId())) {
            throw new BadUserCredentialsException("Either passport id or session key must be present");
        }
        UserCredentialsAuthValidationResult check = authValidator
                .validate(userCredentials.getPassportId(), userCredentials.getLogin(), userCredentials.getUserTicket());
        if (!check.isOk()) {
            throw new BadUserCredentialsException(check.getDescription());
        }
    }
}
