package ru.yandex.travel.credentials;

import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.servlet.HandlerInterceptor;

@Slf4j
public class UserLoggedInHandlerInterceptor implements HandlerInterceptor {
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        // checking credentials for other dispatchers is not safe
        // e.g. ASYNC dispatcher loses UserCredentials set inside the filter
        if (request.getDispatcherType() == DispatcherType.REQUEST) {
            UserCredentials userCredentials = UserCredentials.get();
            // this handler is used with UserCredentialsValidationHandlerInterceptor so here we assume that user credentials
            // are present and valid
            Preconditions.checkNotNull(userCredentials, "User credentials must be provided");
            if (!userCredentials.isLoggedIn()) {
                log.warn("The user should be logged in to call this service; userCredentials={}", userCredentials);
                throw new ForbiddenException();
            }
        }
        return true;
    }
}
