package ru.yandex.travel.grpc;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value = "grpc", ignoreUnknownFields = false)
@Getter
@Setter
public class GrpcServerProperties {
    private boolean enabled;

    private int port;

    private boolean enableThreadPoolExecutor = false;

    private boolean enableReflectionService = false;

    private int threadPoolSize = 8;

    private String threadPoolName;

    private boolean daemonThreads;

    private boolean reportErrorsToSentry;

    @Data
    public static class TracingConfig {
        private boolean enabled;
    }

    private TracingConfig tracing;
}
